/*
	config.c
*/
#include <windows.h>
#include <scrnsave.h>
#include <string.h>

#include <commctrl.h>

#include "resource.h"
#include "general.h"
#include "config.h"

int _config_wireframe = FALSE;
int _config_addedges = TRUE;
int _config_edgewidth = 5;

int _config_count = 40;

int _config_objectrot_X = 0;
int _config_objectrot_Y = 0;
int _config_objectrot_Z = 0;

int _config_backfaceculling = 0;

int _config_buffering = 0;
unsigned int _config_delay = 15;



void getConfig()
{
	HKEY key;
	//DWORD lpdw;
	if (RegOpenKeyEx( HKEY_CURRENT_USER,
		"Software\\StonerviewW32", 0, KEY_QUERY_VALUE, &key) == ERROR_SUCCESS)
	{
		DWORD dsize = sizeof(_config_wireframe);
		DWORD dwtype =  0;
		RegQueryValueEx(key,"wireframe", NULL, &dwtype, (BYTE*)&_config_wireframe, &dsize);
		RegQueryValueEx(key,"addedges", NULL, &dwtype, (BYTE*)&_config_addedges, &dsize);
		RegQueryValueEx(key,"edgewidth", NULL, &dwtype, (BYTE*)&_config_edgewidth, &dsize);
		RegQueryValueEx(key,"objrotX", NULL, &dwtype, (BYTE*)&_config_objectrot_X, &dsize);
		RegQueryValueEx(key,"objrotY", NULL, &dwtype, (BYTE*)&_config_objectrot_Y, &dsize);
		RegQueryValueEx(key,"objrotZ", NULL, &dwtype, (BYTE*)&_config_objectrot_Z, &dsize);
		RegQueryValueEx(key,"backfaceculling", NULL, &dwtype, (BYTE*)&_config_backfaceculling, &dsize);
		RegQueryValueEx(key,"rendertobitmap", NULL, &dwtype, (BYTE*)&_config_buffering, &dsize);
		RegQueryValueEx(key,"delay", NULL, &dwtype, (BYTE*)&_config_delay, &dsize);
		RegQueryValueEx(key,"count", NULL, &dwtype, (BYTE*)&_config_count, &dsize);
	//Finished with key
		RegCloseKey(key);
	}
	// If the key can't be found the defaults are used
}
void writeConfig(HWND hDlg)
{
	HKEY key;
	DWORD lpdw;
	if (RegCreateKeyEx( HKEY_CURRENT_USER,
		"Software\\StonerviewW32",0,"",//ptr to null-term string specifying the object type of this key
		REG_OPTION_NON_VOLATILE,
		KEY_WRITE,
		NULL,
		&key,
		&lpdw) == ERROR_SUCCESS)

	{
		RegSetValueEx(key,"wireframe", 0, REG_DWORD, 
			(BYTE*)&_config_wireframe, sizeof(_config_wireframe));
		RegSetValueEx(key,"addedges", 0, REG_DWORD, 
			(BYTE*)&_config_addedges, sizeof(_config_addedges));
		RegSetValueEx(key,"edgewidth", 0, REG_DWORD, 
			(BYTE*)&_config_edgewidth, sizeof(_config_edgewidth));
		
		RegSetValueEx(key,"objrotX", 0, REG_DWORD, 
			(BYTE*)&_config_objectrot_X, sizeof(_config_objectrot_X));
		RegSetValueEx(key,"objrotY", 0, REG_DWORD, 
			(BYTE*)&_config_objectrot_Y, sizeof(_config_objectrot_Y));
		RegSetValueEx(key,"objrotZ", 0, REG_DWORD, 
			(BYTE*)&_config_objectrot_Z, sizeof(_config_objectrot_Z));
		
		RegSetValueEx(key,"backfaceculling", 0, REG_DWORD, 
			(BYTE*)&_config_backfaceculling, sizeof(_config_backfaceculling));
		RegSetValueEx(key,"rendertobitmap", 0, REG_DWORD, 
			(BYTE*)&_config_buffering, sizeof(_config_buffering));
		RegSetValueEx(key,"delay", 0, REG_DWORD, 
			(BYTE*)&_config_delay, sizeof(_config_delay));
		RegSetValueEx(key,"count", 0, REG_DWORD, 
			(BYTE*)&_config_count, sizeof(_config_count));
		//Finished with keys
		RegCloseKey(key);
	}
}

// the configuration dialog
// required by scrnsave.lib
BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) {
	HWND aCheck;
	char crtext[500] = ""; // buffer for evrything
	int parse;

	switch ( message ) 
	{
	case WM_INITDIALOG:
		LoadString(hMainInstance, IDS_DESCRIPTION, szAppName, 40);
		getConfig();
		// wireframe checkbox
		aCheck = GetDlgItem( hDlg, IDC_CHECK1 );
		SendMessage( aCheck, BM_SETCHECK, _config_wireframe ? BST_CHECKED : BST_UNCHECKED, 0 );
		// edge drawing checkbox
		aCheck = GetDlgItem( hDlg, IDC_CHECK2 );
		SendMessage( aCheck, BM_SETCHECK, _config_addedges ? BST_CHECKED : BST_UNCHECKED, 0 );

// object rotation
		aCheck = GetDlgItem( hDlg, IDC_CHECK_OX );
		SendMessage( aCheck, BM_SETCHECK, _config_objectrot_X ? BST_CHECKED : BST_UNCHECKED, 0 );
		aCheck = GetDlgItem( hDlg, IDC_CHECK_OY );
		SendMessage( aCheck, BM_SETCHECK, _config_objectrot_Y ? BST_CHECKED : BST_UNCHECKED, 0 );
		aCheck = GetDlgItem( hDlg, IDC_CHECK_OZ );
		SendMessage( aCheck, BM_SETCHECK, _config_objectrot_Z ? BST_CHECKED : BST_UNCHECKED, 0 );
// backface culling
		aCheck = GetDlgItem( hDlg, IDC_CHECK_BFC );
		SendMessage( aCheck, BM_SETCHECK, _config_backfaceculling ? BST_CHECKED : BST_UNCHECKED, 0 );
// buffering
		aCheck = GetDlgItem( hDlg, IDC_CHECK_RTBM );
		SendMessage( aCheck, BM_SETCHECK, _config_buffering ? BST_CHECKED : BST_UNCHECKED, 0 );

		// set the text in the edit control
		aCheck = GetDlgItem( hDlg, IDC_EDIT1 );
		strcat(crtext, "StonerViewW32 ");
		strcat(crtext, VERSION_STRING);
		strcat(crtext, "\r\nby Peter Kliem (peter@kliemax.de) in January 2003\r\n"); 
		strcat(crtext, "based on StonerView v1.3 by Andrew Plotkin (erkyrath@eblong.com)");
		strcat(crtext, "\r\noriginal: http://www.eblong.com/zarf/stonerview.html");
		strcat(crtext, "\r\n\r\n This program is published under the GNU Public License (GPL)");
		SendMessage(aCheck, WM_SETTEXT, 0, (LPSTR) crtext);

		// set the text for the edge width
		aCheck = GetDlgItem( hDlg, IDC_EDIT2 );
		sprintf(crtext, "%d", _config_edgewidth); 
		SendMessage(aCheck, WM_SETTEXT, 0, (LPSTR) crtext);


		aCheck = GetDlgItem( hDlg, IDC_SPIN1 );
		SendMessage (aCheck, UDM_SETRANGE, 0L, MAKELONG (100, 1));		

		// set the text for the delay
		aCheck = GetDlgItem( hDlg, IDC_EDIT_DELAY );
		sprintf(crtext, "%d", _config_delay); 
		SendMessage(aCheck, WM_SETTEXT, 0, (LPSTR) crtext);

		aCheck = GetDlgItem( hDlg, IDC_SPIN_DELAY );
		SendMessage (aCheck, UDM_SETRANGE, 0L, MAKELONG (1000, 1));		

		// set the text for count
		aCheck = GetDlgItem( hDlg, IDC_EDIT_COUNT );
		sprintf(crtext, "%d", _config_count); 
		SendMessage(aCheck, WM_SETTEXT, 0, (LPSTR) crtext);

		aCheck = GetDlgItem( hDlg, IDC_SPIN_COUNT );
		SendMessage (aCheck, UDM_SETRANGE, 0L, MAKELONG (COUNT_MAX, COUNT_MIN));		
		
		return TRUE;
	case WM_COMMAND:
		switch( LOWORD( wParam ) ) 
		{ 
		case IDC_CHECK1: // wireframe
			_config_wireframe = (IsDlgButtonChecked( hDlg, IDC_CHECK1) == BST_CHECKED);
			return TRUE;
		case IDC_CHECK2: // addedges
			_config_addedges = (IsDlgButtonChecked( hDlg, IDC_CHECK2) == BST_CHECKED);
			return TRUE;

		case IDC_CHECK_OX:
			_config_objectrot_X = (IsDlgButtonChecked( hDlg, IDC_CHECK_OX) == BST_CHECKED);
			return TRUE;
		case IDC_CHECK_OY:
			_config_objectrot_Y = (IsDlgButtonChecked( hDlg, IDC_CHECK_OY) == BST_CHECKED);
			return TRUE;
		case IDC_CHECK_OZ:
			_config_objectrot_Z = (IsDlgButtonChecked( hDlg, IDC_CHECK_OZ) == BST_CHECKED);
			return TRUE;

		case IDC_CHECK_BFC: // backface culling
			_config_backfaceculling = (IsDlgButtonChecked( hDlg, IDC_CHECK_BFC) == BST_CHECKED);
			return TRUE;
		case IDC_CHECK_RTBM: // buffering
			_config_buffering = (IsDlgButtonChecked( hDlg, IDC_CHECK_RTBM) == BST_CHECKED);
			return TRUE;



		case IDC_EDIT2: // edgewidth text control
			if (EN_KILLFOCUS == HIWORD(wParam)) {
				GetDlgItemText(hDlg, IDC_EDIT2, (LPSTR) crtext, 10);
				if (sscanf(crtext, "%d", &parse)) { 
					{
						if (parse < 1) _config_edgewidth=1; 
						else if (parse > 100) _config_edgewidth = 100; 
						else _config_edgewidth = parse;
					}
					// set the corrected value in the dit control
					sprintf(crtext, "%d", _config_edgewidth); 
					SetDlgItemText(hDlg, IDC_EDIT2, (LPSTR)crtext);
				}
			}
			return TRUE;
		case IDC_EDIT_DELAY: // delay text control
			if (EN_KILLFOCUS == HIWORD(wParam)) {
				GetDlgItemText(hDlg, IDC_EDIT_DELAY, (LPSTR) crtext, 10);
				if (sscanf(crtext, "%d", &parse)) { 
					{
						if (parse < 1) _config_delay=1; 
						else if (parse > 1000) _config_delay = 1000; 
						else _config_delay = parse;
					}
					// set the corrected value in the dit control
					sprintf(crtext, "%d", _config_delay); 
					SetDlgItemText(hDlg, IDC_EDIT_DELAY, (LPSTR)crtext);
				}
			}
		case IDC_EDIT_COUNT: // count text control
			if (EN_KILLFOCUS == HIWORD(wParam)) {
				GetDlgItemText(hDlg, IDC_EDIT_COUNT, (LPSTR) crtext, 10);
				if (sscanf(crtext, "%d", &parse)) { 
					{
						if (parse < COUNT_MIN) _config_count=COUNT_MIN; 
						else if (parse > COUNT_MAX) _config_count = COUNT_MAX; 
						else _config_count = parse;
					}
					// set the corrected value in the dit control
					sprintf(crtext, "%d", _config_count); 
					SetDlgItemText(hDlg, IDC_EDIT_COUNT, (LPSTR)crtext);
				}
			}
			return TRUE;

		case IDOK:
			writeConfig(hDlg);//get info from controls
			EndDialog( hDlg, LOWORD( wParam ) == IDOK ); 
			return TRUE; 
		case IDCANCEL: 
			EndDialog( hDlg, LOWORD( wParam ) == IDOK ); 
			return TRUE;   
		}
	}//end command switch
	return FALSE; 
}
