/*
	config.h 
	header for the configuration of stonerviewW32

*/
#include <windows.h>
#include  <GL/gl.h>

#define VERSION_STRING "v1.2 03/03/2002"

extern int _config_wireframe;
extern int _config_addedges;
// ranges from 1 to 100 and is converted to float before use
extern int _config_edgewidth;

// the number of objects ranges from 5 to 300
extern int _config_count;

#define COUNT_MAX 300
#define COUNT_MIN 5

// rotation of the objects itself
extern int _config_objectrot_X;
extern int _config_objectrot_Y;
extern int _config_objectrot_Z;

// should backface culling be used?
extern int _config_backfaceculling;

// render to a bitmap, may be useful when using general
// openGL implementation with win2k or winxp
int _config_buffering ;
// delay beetween frames in ms
unsigned int _config_delay ;


/*
* read config from registry
*/
extern void getConfig();
/*
* write config ro registry
*/
extern void writeConfig(HWND hDlg);
/*
* handling of the configuration dialog
*/
extern BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
