/*
	StonerviewW32 is a port of StonerView by Andrew Plotkin availabe for Linux and Mac
	to the win32 Platform

	The original StonerView is Copyright 1998-2001 by Andrew Plotkin (erkyrath@eblong.com)
	http://www.eblong.com/zarf/stonerview.html

	Stonerview itself is based on ideas of Electropaint by Silicon Graphics which was
	shipped with the Iris Indigo machines (and maybe it is still shipped with
	newer SGI machines - I don't know)
	
	Many thanks go to Rachel Grey (lemming@alum.mit.edu) for her tutorial on how
	to write a windows openGL screensaver (http://www.cityintherain.com/howtoscr.html). Parts of her 
	source code are in here.
	Another thank you goes to Jeff Molofee (http://nehe.gamedev.net/)for the openGL tutorial bringing 
	me right to the point.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. (It should be a document entitled "Copying".) 
	If not, see the web URL above, or write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA




Revision History
	03/03/2003 V1.2 - more options
					- do not use rendering to bitmap if not configured
	01/26/2003 V1.1 added a configuration dialog and some options
	01/25/2003 V1.0 the basic port of StonerView works

*/
#include <windows.h>
#include <scrnsave.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <string.h>

#include <commctrl.h>

#include "resource.h"

#include "general.h"
#include "move.h"
#include "view.h"
#include "config.h"


#define MYTIMERID 100

//These forward declarations are just for readability,
//so the big three functions can come first 
void InitGL(HWND hWnd, HDC hDC, HGLRC hRC);
void CloseGL(HWND hWnd, HDC hDC, HGLRC hRC);
void SetupAnimation(int Width, int Height);
void CleanupAnimation();
void OnTimer(HDC hDC);
int Width, Height; //globals for size of screen


static void InitGL(HWND hWnd, HDC hDC, HGLRC hRC)
{
  
  int i;
  PIXELFORMATDESCRIPTOR pfd;
  ZeroMemory( &pfd, sizeof pfd );
  pfd.nSize = sizeof pfd;
  pfd.nVersion = 1;
  //pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL; //blaine's
  pfd.dwFlags = PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  pfd.iPixelType = PFD_TYPE_RGBA;
  pfd.cColorBits = 24;
  
  hDC = GetDC( hWnd );
  
  i = ChoosePixelFormat( hDC, &pfd );  
  SetPixelFormat( hDC, i, &pfd );
  hRC = wglCreateContext( hDC );
  wglMakeCurrent( hDC, hRC );
}
// Shut down OpenGL
static void CloseGL(HWND hWnd, HDC hDC, HGLRC hRC)
{
  wglMakeCurrent( NULL, NULL );
  wglDeleteContext( hRC );
  ReleaseDC( hWnd, hDC );
}




// needed for SCRNSAVE.LIB
BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
	return TRUE;
}

#define ClearColor  0.0f, 0.0f, 0.0f, 1.0f
#define Cyan        0.0f, 1.0f, 1.0f, 1.0f
#define Yellow      1.0f, 1.0f, 0.0f, 1.0f
#define Magenta     1.0f, 0.0f, 1.0f, 1.0f
#define Red         1.0f, 0.0f, 0.0f, 1.0f
#define Green       0.0f, 1.0f, 0.0f, 1.0f
#define Blue        0.0f, 0.0f, 1.0f, 1.0f
#define White       1.0f, 1.0f, 1.0f, 1.0f
#define Black       0.0f, 0.0f, 0.0f, 1.0f

/* Prototypes... */
LRESULT WINAPI ScreenSaverProc(HWND hWnd, UINT message, 
							   WPARAM wParam, LPARAM lParam);
static BOOL InitPixelFormat(HDC hDC, int iBPP, PIXELFORMATDESCRIPTOR *pfd);
static HBITMAP CreateCompatibleDIB(HDC hDC, HPALETTE hPalette, int iWidth, int iHeight);
static BOOL PrepareOpenGL(RECT *clientrect);
static BOOL RenderAndBlt(HWND hWnd, HDC hDC, int iDestWidth, int iDestHeight, HDC hMemDC, int iSrcWidth, int iSrcHeight);
HPALETTE CreateRGBPalette(HDC hDC);
HINSTANCE hInst;

void doDraw(HDC hDC) {
    win_draw();
	glFinish();
	SwapBuffers(hDC);
}


// ScreenSaverProc
// Main screensaving 
// required by scrnsave.lib
LRESULT WINAPI ScreenSaverProc(HWND hWnd, UINT message, 
							   WPARAM wParam, LPARAM lParam)
{
	static HGLRC hRC = NULL;
	static HDC hDC = NULL;
	static HDC hMemDC = NULL;
	static BOOL bDoubleBuffered;
	static BOOL bRecreateDIBOnResize = TRUE;
	static HBITMAP hBitmap = NULL;
	static HGDIOBJ hOldBitmap;
	static HPALETTE hPalette = NULL;
	static HPALETTE hOldPalette = NULL;
	RECT rect;
	DIBSECTION ds;
	BOOL bResult;
	PAINTSTRUCT ps;
	PIXELFORMATDESCRIPTOR pfd;
	int iBPP;
	char buf[1000];

	switch (message)
	{
	case WM_CREATE:
		// Read the configuration
		getConfig();

		if (_config_buffering) {	
			// Get DC for client window...
			hDC = GetDC(hWnd);
			if (!hDC)
			{
				MessageBox(hWnd, "WM_CREATE - GetDC failed", "GLDib", MB_OK);
				return 0;
			}

			// Must set pixel format for window DC only so we can create a meaningful palette...
			iBPP = GetDeviceCaps(hDC, BITSPIXEL) * GetDeviceCaps(hDC, PLANES);
			if (iBPP == 8)
			{
				bResult = InitPixelFormat(hDC, iBPP, &pfd);
				if (!bResult)
				{
					MessageBox(hWnd, "WM_SIZE - SetPixelFormat failed", "GLDib", MB_OK);
					DestroyWindow(hWnd);
					return 0;
				}
				hPalette = CreateRGBPalette(hDC);
				hOldPalette = SelectPalette(hDC, hPalette, FALSE);
				RealizePalette(hDC);
			}
		} else {
			hDC = GetDC(hWnd);
			InitGL(hWnd, hDC, hRC);
		}

		bResult = SetTimer(hWnd, MYTIMERID, _config_delay, NULL);
	
		return 0;

	case WM_SIZE:
		GetClientRect(hWnd, &rect);
		if (_config_buffering) {
			if (rect.right > 0 && rect.bottom > 0)
			{
				// Cleanup old DIBSection and memory DC...
				wglMakeCurrent(NULL, NULL);
				if (hBitmap)
				{
					SelectObject(hMemDC, hOldBitmap);
					DeleteObject(hBitmap);
					hBitmap = NULL;
				}
				if (hMemDC)
				{
					DeleteDC(hMemDC);
					hMemDC = NULL;
				}

				// Create new DIBSection of current window size and color config...
				hBitmap = CreateCompatibleDIB(hDC, hPalette, rect.right-rect.left, rect.bottom-rect.top);
				if (!hBitmap)
				{
					MessageBox(hWnd, "WM_SIZE - Create24bppDIBSection failed", "GLDib", MB_OK);
					DestroyWindow(hWnd);
					return 0;
				}
				// Create a window-compatible memory DC and select DIBSection into it...
				hMemDC = CreateCompatibleDC(hDC);
				if (!hMemDC)
				{
					MessageBox(hWnd, "WM_SIZE - CreateCompatibleDC failed", "GLDib", MB_OK);
					DestroyWindow(hWnd);
					return 0;
				}
				hOldBitmap = SelectObject(hMemDC, hBitmap);

				// Create and set pixel format for memory DC...
				bResult = InitPixelFormat(hMemDC, GetDeviceCaps(hDC, BITSPIXEL) * GetDeviceCaps(hDC, PLANES), &pfd);
				if (!bResult)
				{
					MessageBox(hWnd, "WM_SIZE - InitPixelFormat failed", "GLDib", MB_OK);
					DestroyWindow(hWnd);
					return 0;
				}

				// Create rendering context (only done first time through WM_SIZE)...
				if (!hRC)
				{
					hRC = wglCreateContext(hMemDC);
					if (!hRC)
					{
						MessageBox(hWnd, "WM_SIZE - wglCreateContext failed", "GLDib", MB_OK);
						DestroyWindow(hWnd);
						return 0;
					}
				}

				// Make rendering context current...
				bResult = wglMakeCurrent(hMemDC, hRC);
				if (!bResult)
				{
					MessageBox(hWnd, "WM_SIZE - wglMakeCurrent failed", "GLDib", MB_OK);
					DestroyWindow(hWnd);
					return 0;
				}

				// Set up OpenGL matrices, viewport, and states...
				bResult = PrepareOpenGL(&rect);
				if (!bResult)
				{
					MessageBox(hWnd, "WM_SIZE - PrepareOpenGL failed", "GLDib", MB_OK);
					DestroyWindow(hWnd);
					return 0;
				}
			}
			// stonerview initialisation
			init_move();
			win_reshape(rect.right, rect.bottom);

			// Force repaint whether we created a new DIBSection or not...
			InvalidateRect(hWnd, NULL, FALSE);
			return 0;
		} else {
			init_move();
			win_reshape(rect.right, rect.bottom);
			break;
		}


	case WM_PAINT:
		if (_config_buffering) {
			BeginPaint(hWnd, &ps);

			GetClientRect(hWnd, &rect);
			GetObject(hBitmap, sizeof(DIBSECTION), &ds);
			bResult = RenderAndBlt(hWnd, hDC, rect.right, rect.bottom, hMemDC, ds.dsBmih.biWidth, ds.dsBmih.biHeight);

			EndPaint(hWnd, &ps);
		return 0;
		}
		break;
	case WM_PALETTECHANGED:
		if (_config_buffering){
		if (hWnd != (HWND) wParam)
		{
			UnrealizeObject(hPalette);
			SelectPalette(hDC, hPalette, TRUE);
			if (RealizePalette(hDC) != GDI_ERROR)
				return 1;
		}
		return 0;
		}
		break;
	case WM_QUERYNEWPALETTE:
		if (_config_buffering) {
		UnrealizeObject(hPalette);
		SelectPalette(hDC, hPalette, FALSE);
		if (RealizePalette(hDC) != GDI_ERROR)
			return 1;
		return 0;
		}
		break;
	case WM_TIMER:
				move_increment();
  			if (_config_buffering) {
				InvalidateRect(hWnd, NULL, FALSE);
			} else {
				doDraw(hDC);
			}
		return 0;
		// Free up resources, and quit...
	case WM_DESTROY:
		{
			KillTimer(hWnd, MYTIMERID);

			if (!_config_buffering) {
				CloseGL(hWnd, hDC, hRC);
			}

			if (hPalette)
			{
				SelectPalette(hDC, hOldPalette, TRUE);
				DeleteObject(hPalette);
			}

			if (hDC)
				ReleaseDC(hWnd, hDC);

			wglMakeCurrent(NULL, NULL);

			if (hMemDC && hBitmap)
				SelectObject(hMemDC, hOldBitmap);

			if (hMemDC)
				DeleteDC(hMemDC);

			if (hBitmap)
				DeleteObject(hBitmap);

			if (hRC)
				wglDeleteContext(hRC);

			PostQuitMessage (0);
			break;
		}

	}

	return DefScreenSaverProc( 
		hWnd, message, wParam, lParam );

} /* end WndProc */


/***********************************************/
/* InitPixelFormat                             */
/*                                             */
/* Fills in an OpenGL pixel format descriptor. */
/***********************************************/
static BOOL InitPixelFormat(HDC hDC, int iBPP, PIXELFORMATDESCRIPTOR *pfd)
{
	DWORD dwType;
	int nPixelFormat;
	BOOL bResult;

	if (!hDC)
		return FALSE;

	dwType = GetObjectType(hDC);

	//
	// Fill in the pixel format descriptor.
	//
	ZeroMemory(pfd, sizeof(PIXELFORMATDESCRIPTOR));
	pfd->nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pfd->nVersion = 1;

	if (dwType == OBJ_MEMDC)
		pfd->dwFlags = PFD_DRAW_TO_BITMAP | PFD_SUPPORT_OPENGL;
	else if (dwType == OBJ_DC)
		pfd->dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL;
	else
		return FALSE;

	pfd->iPixelType = PFD_TYPE_RGBA;
	pfd->cColorBits = iBPP;
	pfd->cDepthBits = 24;
	pfd->iLayerType = PFD_MAIN_PLANE;

	nPixelFormat = ChoosePixelFormat(hDC, pfd);
	if (nPixelFormat <= 0)
		return FALSE;
	bResult = SetPixelFormat(hDC, nPixelFormat, pfd);
	if (!bResult)
		return FALSE;

	return TRUE;

} /* end InitPixelFormat */


/**********************************************************************/
/* CreateCompatibleDIB                                                */
/*                                                                    */
/* Create a DIB section with an optimal format for the specified hDC. */
/**********************************************************************/
static HBITMAP CreateCompatibleDIB(HDC hDC, HPALETTE hPalette, int iWidth, int iHeight)
{
    HBITMAP hBitmap = NULL;
	HBITMAP hBitmapDevice = NULL;
    BYTE aj[sizeof(BITMAPINFO) + (sizeof(RGBQUAD) * 255)];
    BITMAPINFO *pbmi = (BITMAPINFO *) aj;
    LPVOID pBits;
    ULONG cColors;
    BYTE ajp[sizeof(PALETTEENTRY) * 256];
    LPPALETTEENTRY lppe = (LPPALETTEENTRY) ajp;
	UINT i;

    // Make sure this is a display DC...
    if (GetObjectType(hDC) != OBJ_DC)
		return NULL;

	// Create a temporary bitmap from which to get display's format...
 	hBitmapDevice = CreateCompatibleBitmap(hDC, 1, 1);
	if (!hBitmapDevice)
		return NULL;

	// Fill in BITMAPINFOHEADER for hBitmapTemp...
	ZeroMemory(pbmi, sizeof(aj));
	pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	GetDIBits(hDC, hBitmapDevice, 0, 0, NULL, pbmi, DIB_RGB_COLORS);

    if (pbmi->bmiHeader.biBitCount <= 8)
    {
		cColors = 1 << pbmi->bmiHeader.biBitCount;
		if (cColors <= 256)
		{
			if (hPalette)
				GetPaletteEntries(hPalette, 0, cColors, lppe);
			else
				GetSystemPaletteEntries(hDC, 0, cColors, lppe);
			for (i = 0; i < cColors; i++)
			{
				pbmi->bmiColors[i].rgbRed      = lppe[i].peRed;
				pbmi->bmiColors[i].rgbGreen    = lppe[i].peGreen;
				pbmi->bmiColors[i].rgbBlue     = lppe[i].peBlue;
				pbmi->bmiColors[i].rgbReserved = 0;
			}
		}
    }
    else
    {
		// Get color masks if needed...
        if (pbmi->bmiHeader.biCompression == BI_BITFIELDS)
			GetDIBits(hDC, hBitmapDevice, 0, pbmi->bmiHeader.biHeight, NULL, pbmi, DIB_RGB_COLORS);
    }

	// Set DIB size to requested size...
	pbmi->bmiHeader.biWidth = iWidth;
	pbmi->bmiHeader.biHeight = iHeight;

	// Create the DIB section...
	hBitmap = CreateDIBSection(hDC, pbmi, DIB_RGB_COLORS, &pBits, NULL, 0);

	if (!hBitmap)
	{
		MessageBox(NULL, "CreateCompatibleDIB - CreateDIBSection failed", "DibUtil", MB_OK);
		return NULL;
	}	

	DeleteObject(hBitmapDevice);

    return hBitmap;
}



/**********************************************************************/
/* PrepareOpenGL                                                      */
/*                                                                    */
/* Simple utility that sets up OpenGL matrices, viewport, and states. */
/**********************************************************************/
static BOOL PrepareOpenGL(RECT *clientrect)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-1.0, 1.0, -1.0, 1.0, 1.5, 20.0);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glTranslatef(0.0f, 0.0f, -3.0f);

	glViewport(0, 0, clientrect->right - clientrect->left, clientrect->bottom - clientrect->top);

	glEnable(GL_CULL_FACE);
	glDrawBuffer(GL_FRONT);
	glDisable(GL_DEPTH_TEST);

	return 1;
}

/*****************************************************/
/* RenderAndBlt                                      */
/*                                                   */
/* Renders rotated cube to DIBSection-backed hMemDC, */
/* then blt's hMemDC to hDC.                         */
/*****************************************************/
static BOOL RenderAndBlt(HWND hWnd, HDC hDC, int iDestWidth, int iDestHeight, HDC hMemDC, int iSrcWidth, int iSrcHeight)
{
	BOOL bResult;

	// Stretch DIBSection to client area (if we are re-rendering in WM_SIZE there is no actual stretching)...
	if (iSrcWidth > 0 && iSrcHeight > 0 && iDestWidth > 0 && iDestHeight > 0)
	{
	//	glClear(GL_COLOR_BUFFER_BIT);

// stoner view drawing
    win_draw();

		bResult = StretchBlt(hDC, 0, 0, iDestWidth, iDestHeight, hMemDC, 0, 0, iSrcWidth, iSrcHeight, SRCCOPY);
		if (!bResult)
			return FALSE;
	}
	else
		return FALSE;

	return TRUE;
}
//////////////////////////////////////////////////////////////////////////////////////
//
// OpenGLpalette
//
unsigned char m_threeto8[8] =
{
    0, 0111>>1, 0222>>1, 0333>>1, 0444>>1, 0555>>1, 0666>>1, 0377
};
unsigned char m_twoto8[4] =
{
   0, 0x55, 0xaa, 0xff
};
unsigned char m_oneto8[2] =
{
    0, 255
};

int m_defaultOverride[13] =
{
    0, 3, 24, 27, 64, 67, 88, 173, 181, 236, 247, 164, 91
};

PALETTEENTRY m_defaultPalEntry[20] =
{
    { 0,   0,   0,    0 }, //0
    { 0x80,0,   0,    0 }, 
    { 0,   0x80,0,    0 }, 
    { 0x80,0x80,0,    0 }, 
    { 0,   0,   0x80, 0 },
    { 0x80,0,   0x80, 0 },
    { 0,   0x80,0x80, 0 },
    { 0xC0,0xC0,0xC0, 0 }, //7

    { 192, 220, 192,  0 }, //8
    { 166, 202, 240,  0 },
    { 255, 251, 240,  0 },
    { 160, 160, 164,  0 }, //11

    { 0x80,0x80,0x80, 0 }, //12
    { 0xFF,0,   0,    0 },
    { 0,   0xFF,0,    0 },
    { 0xFF,0xFF,0,    0 },
    { 0,   0,   0xFF, 0 },
    { 0xFF,0,   0xFF, 0 },
    { 0,   0xFF,0xFF, 0 },
    { 0xFF,0xFF,0xFF, 0 }  //19
  };

//
// ComponentFromIndex
//
unsigned char ComponentFromIndex(int i, UINT nbits, UINT shift)
{
    unsigned char val;

    val = (unsigned char) (i >> shift);
    switch (nbits)
	{

		case 1:
			val &= 0x1;
			return m_oneto8[val];

		case 2:
			val &= 0x3;
			return m_twoto8[val];

		case 3:
			val &= 0x7;
			return m_threeto8[val];

		default:
			return 0;
	}
}

//
// CreateRGBPalette
//
HPALETTE CreateRGBPalette(HDC hDC)
{
	HPALETTE hPal;
	LOGPALETTE *pPal;
	PIXELFORMATDESCRIPTOR pfd;
	int n;
	int i, j;

	//
	// Check to see if we need a palette
	//
	ZeroMemory(&pfd, sizeof(PIXELFORMATDESCRIPTOR));
    n = GetPixelFormat(hDC);
	if (n == 0)
		return NULL;
    DescribePixelFormat(hDC, n, sizeof(PIXELFORMATDESCRIPTOR), &pfd);
	if (!(pfd.dwFlags & PFD_NEED_PALETTE))
		return FALSE;

    // allocate a log pal and fill it with the color table info
    pPal = (LOGPALETTE*) malloc(sizeof(LOGPALETTE) 
								+ 256 * sizeof(PALETTEENTRY));
    if (!pPal) 
		return NULL;
    pPal->palVersion = 0x300; // Windows 3.0
    pPal->palNumEntries = 256; // table size

	//
	// Create RGB Palette
	//
	if (pfd.cColorBits != 8)
	{
		free(pPal);
		return NULL;
	}
	n = 1 << pfd.cColorBits;
    for (i=0; i<n; i++)
    {
        pPal->palPalEntry[i].peRed =
                ComponentFromIndex(i, pfd.cRedBits, pfd.cRedShift);
        pPal->palPalEntry[i].peGreen =
                ComponentFromIndex(i, pfd.cGreenBits, pfd.cGreenShift);
        pPal->palPalEntry[i].peBlue =
                ComponentFromIndex(i, pfd.cBlueBits, pfd.cBlueShift);
        pPal->palPalEntry[i].peFlags = 0;
    }

	//
	// Fix up color table with system colors.
	//
    if ((pfd.cColorBits == 8)                           &&
        (pfd.cRedBits   == 3) && (pfd.cRedShift   == 0) &&
        (pfd.cGreenBits == 3) && (pfd.cGreenShift == 3) &&
        (pfd.cBlueBits  == 2) && (pfd.cBlueShift  == 6)
       )
    {
	    for (j = 1 ; j <= 12 ; j++)
	          pPal->palPalEntry[m_defaultOverride[j]] = m_defaultPalEntry[j];
	}

    hPal = CreatePalette(pPal);
    free(pPal);

	return hPal;
}





