/* StonerView: An eccentric visual toy.
Copyright 1998-2001 by Andrew Plotkin (erkyrath@eblong.com)
http://www.eblong.com/zarf/stonerview.html
This program is distributed under the GPL.

See stvW32Main.c, the Copying document, or the above URL for details.

modified by Peter Kliem (peter@kliemax.de)

*/
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include "general.h"
#include "osc.h"
#include "view.h"

#include "move.h"
#include "config.h"

static GLfloat view_rotx = -45.0, view_roty = 0.0, view_rotz = 0.0;
static GLfloat view_scale = 4.0;
static GLfloat angle = 0.0f;

static void setup_window(void);
void win_reshape(int width, int height);


int init_view(int width, int height)
{
	setup_window();
	win_reshape(width, height);

	return TRUE;
}

static void setup_window()
{
// enable/disable backfaceculling according to config
	if (_config_backfaceculling) {
		glEnable(GL_CULL_FACE);
	} else {
		glDisable(GL_CULL_FACE);
	}

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_DEPTH_TEST);

	glEnable(GL_NORMALIZE);
}


/* callback: draw everything */
void win_draw(void)
{
	GLfloat orotx = (_config_objectrot_X ? 1.0f : 0.0f);
	GLfloat oroty = (_config_objectrot_Y ? 1.0f : 0.0f);
	GLfloat orotz = (_config_objectrot_Z ? 1.0f : 0.0f);
	int orot = (_config_objectrot_X||_config_objectrot_Y||_config_objectrot_Z);

	int ix;

	static GLfloat white[] = { 1.0, 1.0, 1.0, 1.0 };
	static GLfloat grey[] =  { 0.6, 0.6, 0.6, 1.0 };
	static GLfloat red[] =  { 1.0, 0.0, 0.0, 1.0 };

	angle = angle + 1.0f;
	if (angle >= 360.0) angle = 0.0;

	glDrawBuffer(GL_BACK);
//	glDrawBuffer(GL_FRONT);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPushMatrix();
	glScalef(view_scale, view_scale, view_scale);
	glRotatef(view_rotx, 1.0, 0.0, 0.0);
	glRotatef(view_roty, 0.0, 1.0, 0.0);
	glRotatef(view_rotz, 0.0, 0.0, 1.0);

	glShadeModel(GL_FLAT);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	if (_config_backfaceculling) {
		glEnable(GL_CULL_FACE);
	} else {
		glDisable(GL_CULL_FACE);
	}

	for (ix=0; ix<_config_count; ix++) {
		elem_t *el = &elist[ix];

		glNormal3f(0.0, 0.0, 1.0);

		if (_config_addedges || _config_wireframe) {

			glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, (_config_wireframe ? white : grey));
// line width
			glLineWidth((GLfloat)_config_edgewidth);
			glPushMatrix();
			// Rotation of the polygons itself
			if (orot) glRotatef(angle, orotx, oroty, orotz);
		glBegin(GL_LINE_LOOP);
			// set the color of the edge (missing (?) in stonerview
			glColor4fv(grey);
			
			glVertex3f(el->pos[0] - el->vervec[0], el->pos[1] - el->vervec[1],
				el->pos[2]);
			glVertex3f(el->pos[0] + el->vervec[1], el->pos[1] - el->vervec[0],
				el->pos[2]);
			glVertex3f(el->pos[0] + el->vervec[0], el->pos[1] + el->vervec[1],
				el->pos[2]);
			glVertex3f(el->pos[0] - el->vervec[1], el->pos[1] + el->vervec[0],
				el->pos[2]);

			glEnd();
			glPopMatrix();
		}

		if (!_config_wireframe) {
			// I'm not shure if this does something useful
			// it's from the original stonerview code
	//		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, el->col);
			glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, el->col);
			glPushMatrix();
// Rotation of the polygons itself
			if (orot) glRotatef(angle, orotx, oroty, orotz);

			glBegin(GL_QUADS);
			// set the color (missing in the original stonerview code
			glColor4fv(el->col);
			glVertex3f(el->pos[0] - el->vervec[0], el->pos[1] - el->vervec[1],
				el->pos[2]);
			glVertex3f(el->pos[0] + el->vervec[1], el->pos[1] - el->vervec[0],
				el->pos[2]);
			glVertex3f(el->pos[0] + el->vervec[0], el->pos[1] + el->vervec[1],
				el->pos[2]);
			glVertex3f(el->pos[0] - el->vervec[1], el->pos[1] + el->vervec[0],
				el->pos[2]);
	

			glEnd();
			
			glPopMatrix();
		}
	}
//	glLoadIdentity();

	glPopMatrix();

	glFinish();

}

/* callback: new window size or exposure */
void win_reshape(int width, int height)
{
	GLfloat h = (GLfloat) height / (GLfloat) width;

	glViewport(0, 0, (GLint) width, (GLint) height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-1.0, 1.0, -h, h, 5.0, 60.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(0.0, 0.0, -40.0);
}

