/**
 * This file is part of ElectroPortis for Android.
 * JNI wrapper for the calls
 * (c) Peter Kliem
 */
#include <jni.h>

#include <GLES/gl.h>
#include <GLES/glext.h>

#include "ep.h"

bool setupGraphics(int width, int height) {
    init_ep();
    reshape__GiT1(width, height);
    return true;
}


EPANOS_ARGS ARGS;

void renderFrame() {
	display__Gv(&ARGS, 1);
}

void setParameter(int shape) {
	epSetParameter(shape);
}

extern "C" {
    JNIEXPORT void JNICALL Java_de_kliemax_electroportis_EPLib_init(JNIEnv * env, jobject obj,  jint width, jint height);
    JNIEXPORT void JNICALL Java_de_kliemax_electroportis_EPLib_step(JNIEnv * env, jobject obj);
    JNIEXPORT void JNICALL Java_de_kliemax_electroportis_EPLib_setParameter(JNIEnv * env, jobject obj, jint shape);
};

JNIEXPORT void JNICALL Java_de_kliemax_electroportis_EPLib_init(JNIEnv * env, jobject obj,  jint width, jint height)
{
    setupGraphics(width, height);
}

JNIEXPORT void JNICALL Java_de_kliemax_electroportis_EPLib_step(JNIEnv * env, jobject obj)
{
    renderFrame();
}

JNIEXPORT void JNICALL JNICALL Java_de_kliemax_electroportis_EPLib_setParameter(JNIEnv * env, jobject obj, jint shape)
{
    setParameter(shape);
}
