/**
 * This file is part of ElectroPortis for Android.
 * All the shape drawing is concentrated in this file.
 * (c) Peter Kliem
 */
#include "shapes.h"

#include <GLES/gl.h>
#include <GLES/glext.h>
#include <math.h>
#include <stdlib.h>


// square vertices
static   GLfloat squareVertices[] = {
      -0.1f, -0.1f,
      0.1f, -0.1f,
      -0.1f,  0.1f,
      0.1f,  0.1f,
  };
static   GLfloat squareOutline[] = {
      -0.1f, -0.1f,
      0.1f, -0.1f,

      0.1f, -0.1f,
      0.1f,  0.1f,

      0.1f,  0.1f,
      -0.1f,  0.1f,

      -0.1f,  0.1f,
      -0.1f, -0.1f,
  };
void drawSquare() {
	  // Render the vertex array
	  glEnableClientState(GL_VERTEX_ARRAY);
	  glVertexPointer(2, GL_FLOAT, 0, squareVertices);
	  glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
	  glDisableClientState(GL_VERTEX_ARRAY);
}
void drawSquareOutline() {
	  // Render the vertex array
	  glEnableClientState(GL_VERTEX_ARRAY);
	  glVertexPointer(2, GL_FLOAT, 0, squareOutline);
	  glDrawArrays(GL_LINES, 0, 8);
	  glDisableClientState(GL_VERTEX_ARRAY);
}




// star vertices
    int _count = 5;
    static GLfloat starVertices[6*9];
    int starInit = 0;
    static short indices[] = {9,0,1, 1,2,3, 3,4,5, 5,6,7, 7,8,9,   1,5,9, 9,3,5, 5,7,9, 9,1,3, 3,7,1};
    static short outlineIndices[] = {    0,1,2, 3,4,5,6,7,8,9 };

    /**
     * Calculate the star vertices
     */
    void initStar() {
        float _innerFactor = 0.35f;
        float _size = 0.2f;
        float _angle = 0.0f;
        float PI = 3.14159265359f;

        float degStep = 360.0f/(float)_count;

        int idx = 0;
        int d = 0;
        for (d = 0;d<_count;d++) {
            float deg = degStep*d;

            float offx = (float) (_size * cos((double) (_angle+deg) * (float) PI / 180.0f));
            float offy = (float) (_size * sin((double)(_angle+deg) * (float) PI / 180.0f));

            starVertices[0+idx] =  offx;
            starVertices[1+idx] =  offy;
            starVertices[2+idx] = 0;

            idx+=3;

            offx = (float) (_size*_innerFactor * cos((double) (_angle+deg+degStep/2) * (float) PI / 180.0f));
            offy = (float) (_size*_innerFactor * sin((double)(_angle+deg+degStep/2) * (float) PI / 180.0f));

            starVertices[0+idx] =  offx;
            starVertices[1+idx] =  offy;
            starVertices[2+idx] = 0;

            idx+=3;
        }
    }



void drawStar() {
	if (!starInit) {
		initStar();
		starInit=1;
	}
	// Render the vertex array
	  glEnableClientState(GL_VERTEX_ARRAY);

      glVertexPointer(3, GL_FLOAT, 0, starVertices);
      glDrawElements(GL_TRIANGLES, 30, GL_UNSIGNED_SHORT, indices);

	  glDisableClientState(GL_VERTEX_ARRAY);
}

void drawStarOutline() {
	if (!starInit) {
		initStar();
		starInit=1;
	}
	// Render the vertex array
	  glEnableClientState(GL_VERTEX_ARRAY);

      glVertexPointer(3, GL_FLOAT, 0, starVertices);
      glDrawElements(GL_LINE_LOOP, 10, GL_UNSIGNED_SHORT, outlineIndices);

	  glDisableClientState(GL_VERTEX_ARRAY);
}
