/*
 * This is part of ElectroPortis for Android. 
 * (c) 2014 Peter Kliem
 */

package de.kliemax.electroportis;

import android.app.Activity;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.WindowManager;

import java.io.File;


public class EPActivity extends Activity {

    EPView mView;

    @Override protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        mView = new EPView(getApplication());
        PreferenceHandler prefHandler = new PreferenceHandler(getApplicationContext(), mView.getRenderer());
	setContentView(mView);
    }

    @Override protected void onPause() {
        super.onPause();
        mView.onPause();
    }

    @Override protected void onResume() {
        super.onResume();
        mView.onResume();
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.xml.menu, menu);
        return super.onCreateOptionsMenu(menu);
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        switch (item.getItemId()) {
            case R.id.prefs:
            	Intent intent = new Intent(this, EPPreferenceActivity.class);
            	startActivity(intent);
                return true;
            case R.id.setwallpaper:
            	Intent setWPIntent = new Intent(WallpaperManager.ACTION_CHANGE_LIVE_WALLPAPER);
            	setWPIntent.putExtra(WallpaperManager.EXTRA_LIVE_WALLPAPER_COMPONENT,
            	    new ComponentName(this, EPWallpaperService.class));
            	  startActivity(setWPIntent);
                return true;
            case R.id.about:
                EPPreferenceActivity.showDialog(this, getString(R.string.about));

                return true;
           default:
                return super.onOptionsItemSelected(item);
        }
    }
}
