/*
 * This file is part of ElectroPortis for Android 
 * 
 * (c) 2014 Peter Kliem
 */
package de.kliemax.electroportis;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.Preference.OnPreferenceClickListener;
import android.widget.Toast;

public class EPPreferenceActivity extends PreferenceActivity implements
        SharedPreferences.OnSharedPreferenceChangeListener {

    final static String SHARED_PREFS_NAME = "ep_settings";

    @Override
    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        getPreferenceManager().setSharedPreferencesName(SHARED_PREFS_NAME);
        addPreferencesFromResource(R.xml.ep_preferences);
        Preference customPref = (Preference) findPreference("defaults");
        customPref.setOnPreferenceClickListener(new OnPreferenceClickListener() {

            public boolean onPreferenceClick(Preference preference) {
                Toast.makeText(getBaseContext(), R.string.defaults_restored, Toast.LENGTH_LONG).show();
                SharedPreferences sharedPreference = getSharedPreferences(SHARED_PREFS_NAME,
                        Activity.MODE_PRIVATE);
                PreferenceHandler.restoreDefaults(sharedPreference);
                return true;
            }

        });
        Preference aboutPref = (Preference) findPreference("about");
        aboutPref.setOnPreferenceClickListener(new OnPreferenceClickListener() {

            public boolean onPreferenceClick(Preference preference) {
                showAboutDialog();
                return true;
            }

        });
    }

    
    protected void showAboutDialog() {
        showDialog(this, getString(R.string.about));
    }

    public static void showDialog(Context context, String text) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage(text).setCancelable(false).setPositiveButton("OK", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.cancel();
            }
        });
        AlertDialog alert = builder.create();
        alert.show();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        
    	getPreferenceManager().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
        super.onDestroy();
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
    }

}