/*
 * This is part of ElectroPortis for Android. 
 * (c) 2014 Peter Kliem
 */
package de.kliemax.electroportis;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import net.rbgrn.android.glwallpaperservice.GLWallpaperService;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;

/**
 * 
 * @author kliem
 *
 */
public class EPRenderer implements GLSurfaceView.Renderer, GLWallpaperService.Renderer {
	static boolean epinitialized = false;
    
	int shape = 0;
	float zoom = -4f;
	int _width;
	int _height;
	GL10 _gl;
	int _speed = 1;
	
	public void onDrawFrame(GL10 gl) {
        EPLib.step();
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        _width = width;
        _height = height;
        _gl = gl;
        
    	if (!epinitialized) {
        	// do not double initialize the library
        	EPLib.init(width, height);
        	epinitialized=true;
        }
        if (height == 0) height = 1;   // To prevent divide by zero
        float aspect = (float)width / height;
     
        // Set the viewport (display area) to cover the entire window
        gl.glViewport(0, 0, width, height);
    
        // Setup perspective projection, with aspect ratio matches viewport
        gl.glMatrixMode(GL10.GL_PROJECTION); // Select projection matrix
        gl.glLoadIdentity();                 // Reset projection matrix
        // Use perspective projection
        GLU.gluPerspective(gl, 300, aspect, 0.01f, 10000.f);
        gl.glTranslatef(0.0f, 0.0f, zoom);
      
        gl.glMatrixMode(GL10.GL_MODELVIEW);  // Select model-view matrix

        // set the parameters for the native lib
        EPLib.setParameter(shape);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);  // Set color's clear-value to black
        gl.glHint(GL10.GL_PERSPECTIVE_CORRECTION_HINT, GL10.GL_NICEST);  // nice perspective view
        gl.glShadeModel(GL10.GL_SMOOTH);   // Enable smooth shading of color
        gl.glDisable(GL10.GL_DITHER);      // Disable dithering for better performance
    }
    
    /**
     * Called when the engine is destroyed. Do any necessary clean up because
     * at this point your renderer instance is now done for.
     */
    public void release() {
    }

    
    public void setShape(int shape){
    	this.shape=shape;
    	EPLib.setParameter(shape);
    }
    
    public void setZoom(float zoom) {
    	this.zoom = zoom;
    	if (_gl != null) {
    	onSurfaceChanged(_gl, _width, _height);
    	}
    }
}
