/*
 * This is part of ElectroPortis for Android. 
 * (c) 2014 Peter Kliem
 */
package de.kliemax.electroportis;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.util.Log;
import net.rbgrn.android.glwallpaperservice.*;

public class EPWallpaperService extends GLWallpaperService {

	public EPWallpaperService() {
		super();
	}

	public Engine onCreateEngine() {
		EPEngine engine = new EPEngine();
		return engine;
	}

	class EPEngine extends GLEngine {
		EPRenderer renderer;

		public EPEngine() {
			super();
			// handle prefs, other initialization
			renderer = new EPRenderer();

			PreferenceHandler prefHandler = new PreferenceHandler(
					getApplicationContext(), renderer);

			setRenderer(renderer);
			setRenderMode(RENDERMODE_CONTINUOUSLY);
		}

		public void onDestroy() {
			super.onDestroy();
			if (renderer != null) {
				renderer.release();
			}
			renderer = null;
		}
	}
}
