/*
 * This is part of ElectroPortis for Android. 
 * (c) 2014 Peter Kliem
 */
package de.kliemax.electroportis;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.util.Log;

public class PreferenceHandler implements OnSharedPreferenceChangeListener {
	public static final String SHAPE = "shape";
	public static final String SHAPE_SQUARE = "square";
	public static final String SHAPE_STAR = "star";

    public static final String ZOOM = "zoom";
    public static final String SPEED = "speed";
    public static final String SIZE = "size";

    EPRenderer _renderer;
    
    public PreferenceHandler(Context context, EPRenderer renderer) {
    	_renderer = renderer;
        SharedPreferences prefs = context.getSharedPreferences(EPPreferenceActivity.SHARED_PREFS_NAME, 0);
        prefs.registerOnSharedPreferenceChangeListener(this);

        apply(prefs);
    }

	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        apply(sharedPreferences, key);
    }

    private void apply(SharedPreferences prefs) {
        apply(prefs, SHAPE);
        apply(prefs, ZOOM);
        apply(prefs, SPEED);
        apply(prefs, SIZE);
    }

    private void apply(SharedPreferences sharedPreferences, String key) {
         if (ZOOM.equals(key)) {
            String zoomStr = sharedPreferences.getString(ZOOM, "-5");
            float zoom = -5f;
            try {
                zoom = Float.parseFloat(zoomStr);
            } catch (Exception e) {
                Log.e("ELECTROPORTIS", "Strange pref", e);
            }
            if (_renderer != null) {
                _renderer.setZoom(zoom);
            }
        } else if (SIZE.equals(key)) {
//            String sizeStr = sharedPreferences.getString(SIZE, "0.11");
//            float size = 0.11f;
//            try {
//                size = Float.parseFloat(sizeStr);
//            } catch (Exception e) {
//                Log.e("STONERVIEW", "Strange pref", e);
//            }
//            if (_renderer != null) {
//                _renderer.setSize(size);
//            }
        } else if (SPEED.equals(key)) {
//            String speedStr = sharedPreferences.getString(SPEED, "1");
//            int speed = 1;
//            try {
//                speed = Integer.parseInt(speedStr);
//            } catch (Exception e) {
//                Log.e("ELECTROPORTIS", "Strange pref", e);
//            }
//            if (_renderer != null) {
//                _renderer.setSpeed(speed);
//            }
        } else if (SHAPE.equals(key)) {
            String shape = sharedPreferences.getString(SHAPE, SHAPE_SQUARE);

            int shapeIdx = 0;
            if (SHAPE_SQUARE.equals(shape)) {
                shapeIdx=0;
            } else if (SHAPE_STAR.equals(shape)) {
                shapeIdx = 1;
            } 

            if (_renderer != null) {
                _renderer.setShape(shapeIdx);
            }
        }
    }

public static void restoreDefaults(SharedPreferences sharedPreference) {
    SharedPreferences.Editor editor = sharedPreference.edit();

    editor.putString(ZOOM, "-5");
//    editor.putString(SPEED, "1");
    editor.putString(SHAPE, SHAPE_SQUARE);
    editor.commit();
}

}
