//
//  ElectroportisView.m
//  Electroportis
//
//  Created by Peter Kliem on 20.01.15.
//  Copyright (c) 2015 Peter Kliem. All rights reserved.
// plese see LICENSE.txt for the license

/*
 Electroportis is a port of the original ElectroPaint (ElectroPaint is a work by David Tristram,
 ElectroPaint is a US trademark owned by Tristram Visual, a sole proprietorship operating in California. Inquiries
 may be directed to info@tristram.com and www.tristram.com). 
 Mark Laws did the amazing work of decompiling the original MIPS assembler to 32bit C code (see https://github.com/drvink/electroportis). This 64bit port (seemed impossible at first) has been done by Peter Kliem (see http://kliemax.de/electroportisosx.html).
 The original decompiled code is distributed with permission. You can freely distribute Electroportis without making changes.
 */



#include <GLUT/glut.h>
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>

#import "ElectroportisView.h"
#include "ep.h"

@implementation ElectroportisView
EPANOS_ARGS ARGS;
bool initialized=false;

// Called every time a window is resized to resize the projection matrix
void reshape(int w, int h)
{
    reshape__GiT1(w, h);
}

- (id)initWithFrame:(NSRect)frame isPreview:(BOOL)isPreview
{
    self.isMainScreen = ((frame.origin.x == 0 && frame.origin.y == 0) || isPreview);
//    NSLog( @"ELECTROPORTIS initwithframe %d pre %d %@",self.isMainScreen,isPreview,self );
    self = [super initWithFrame:frame isPreview:isPreview];
    if (self)
    {
        self.glView = [self createGLView];
        [self addSubview:self.glView];
        [self setAnimationTimeInterval:1/30.0];
    }
    return self;
}

- (NSOpenGLView *)createGLView
{
    NSOpenGLPixelFormatAttribute attribs[] = {
        NSOpenGLPFAAccelerated,
        0
    };
    
    NSOpenGLPixelFormat* format = [[NSOpenGLPixelFormat alloc] initWithAttributes:attribs];
    NSOpenGLView* glview = [[NSOpenGLView alloc] initWithFrame:NSZeroRect pixelFormat:format];
    
    NSAssert(glview, @"Unable to create OpenGL view!");
    
    return glview;
}

- (void)dealloc
{
    [self.glView removeFromSuperview];
    self.glView = nil;
}


- (void)startAnimation
{
    [super startAnimation];
    [[self.glView openGLContext] makeCurrentContext];

    glClearColor(0.0, 0.0, 0.0, 0.0);
    glEnable(GL_DEPTH_TEST);
    glShadeModel(GL_SMOOTH);
    if (self.isMainScreen && !initialized) {
        init_ep();
        initialized=true;
    }
    reshape([self frame].size.width, [self frame].size.height);
}

- (void)stopAnimation
{
    [super stopAnimation];
}

- (void)drawRect:(NSRect)rect
{
    [super drawRect:rect];
//    NSLog( @"ELECTROPORTIS drawrect %d  %@",self.isMainScreen,self );
}

- (void)animateOneFrame
{
 //   NSLog( @"ELECTROPORTIS animateOneFrame %d  %@",self.isMainScreen,self );
    [[self.glView openGLContext] makeCurrentContext];
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    display__Gv(&ARGS, 1);
    return;
}

- (void)setFrameSize:(NSSize)newSize
{
 //   NSLog( @"ELECTROPORTIS setFrameSize %d  %@",self.isMainScreen,self );
    [[self.glView openGLContext] makeCurrentContext];
    [super setFrameSize:newSize];
    [self.glView setFrameSize:newSize];
    reshape(newSize.width, newSize.height);
}


- (BOOL) hasConfigureSheet
{
    return YES;
}

- (NSWindow *)configureSheet
{
    if (!configSheet)
    {
        
        if (![NSBundle loadNibNamed:@"configSheet" owner:self])
        {
            NSLog( @"Failed to load configure sheet." );
            NSBeep();
        }
    }
    
    return configSheet;
}
@end
