/**
 * Part of ELectroPortis for OSX.
 * Based on replay_draw.cpp by Mark Laws.
 * See https://github.com/drvink/electroportis
 *
 * Adapted by Peter Kliem. The original replay function using several windows does not make any sense for LWP -> removed.
 * Basically this warps all openGL calls.
 */

#include "replay_draw.h"

void wrap_glColor3f(GLfloat r, GLfloat g, GLfloat b, const wincount_t wincount) {
    glColor4f(r, g, b, (GLfloat) 1.0f);
}

void wrap_glPushMatrix(const wincount_t wincount) {
    glPushMatrix();
}

void wrap_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z,
                    const wincount_t wincount) {
    glRotatef(angle, x, y, z);
}

void wrap_glTranslatef(GLfloat x, GLfloat y, GLfloat z,
                       const wincount_t wincount) {
    glTranslatef(x, y, z);
}

void wrap_glPopMatrix(const wincount_t wincount) {
    glPopMatrix();
}

void wrap_glScalef(GLfloat x, GLfloat y, GLfloat z, const wincount_t wincount) {
    glScalef(x, y, z);
}

void wrap_glBegin(GLenum mode, const wincount_t wincount) {
    glBegin(mode);
}

void wrap_glVertex2f(GLfloat x, GLfloat y, const wincount_t wincount) {
    glVertex2f(x, y);
}

void wrap_glEnd(const wincount_t wincount) {
    glEnd();
}

void wrap_glClear(GLbitfield mask, const wincount_t wincount) {
    glClear(mask);
}

void wrap_glFinish(const wincount_t wincount) {
    glFinish();
}

