/**
 * Based on replay_draw.hpp by Mark Laws.
 * See https://github.com/drvink/electroportis
 */
#pragma once
#include <GLUT/glut.h>
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>

typedef unsigned long wincount_t;

void wrap_glColor3f(GLfloat r, GLfloat g, GLfloat b, const wincount_t wincount);
void wrap_glPushMatrix(const wincount_t wincount);
void wrap_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z, const wincount_t wincount);
void wrap_glTranslatef(GLfloat x, GLfloat y, GLfloat z, const wincount_t wincount);
void wrap_glPopMatrix(const wincount_t wincount);
void wrap_glScalef(GLfloat x, GLfloat y, GLfloat z, const wincount_t wincount);
void wrap_glBegin(GLenum mode, const wincount_t wincount);
void wrap_glVertex2f(GLfloat x, GLfloat y, const wincount_t wincount);
void wrap_glEnd(const wincount_t wincount);
void wrap_glClear(GLbitfield mask, const wincount_t wincount);
void wrap_glFinish(const wincount_t wincount);
